/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer;

import com.mrcrayfish.furniture.refurbished.computer.Computer;
import com.mrcrayfish.furniture.refurbished.computer.Program;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Icon;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class Display {
    private static Display instance;
    private final Map<Class<? extends Program>, Function<Program, DisplayableProgram<? extends Program>>> programs = new HashMap<Class<? extends Program>, Function<Program, DisplayableProgram<? extends Program>>>();
    private Map<class_2960, Icon> icons;

    public static Display get() {
        if (instance == null) {
            instance = new Display();
        }
        return instance;
    }

    public <T extends Program, D extends DisplayableProgram<T>> void bind(Class<T> programClass, Function<T, D> displayableProvider) {
        this.programs.putIfAbsent(programClass, displayableProvider);
    }

    public <T extends Program> DisplayableProgram<T> getDisplay(T program) {
        return this.programs.get(program.getClass()).apply(program);
    }

    @Nullable
    public Icon getIcon(class_2960 programId) {
        if (this.icons == null) {
            this.icons = this.computeIconMap();
        }
        return this.icons.get(programId);
    }

    private Map<class_2960, Icon> computeIconMap() {
        HashMap<class_2960, Icon> icons = new HashMap<class_2960, Icon>();
        HashMap textures = new HashMap();
        HashMap indexTracker = new HashMap();
        Computer.get().getPrograms().forEach(id -> {
            String namespace = id.method_12836();
            textures.putIfAbsent(namespace, class_2960.method_60655((String)namespace, (String)"textures/gui/program_icons.png"));
            int nextIndex = indexTracker.getOrDefault(namespace, -1) + 1;
            indexTracker.put(namespace, nextIndex);
            icons.put((class_2960)id, new Icon((class_2960)textures.get(namespace), nextIndex % 8 * 16, nextIndex / 8 * 16));
        });
        return icons;
    }
}

